package com.ajb.common.utils.http;

import java.io.IOException;
import java.io.InputStream;

import com.ajb.car.vo.zhima.TokenZhiMa;
import com.ajb.common.utils.string.StringUtil;
import com.alibaba.fastjson.JSON;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpHelpZhiMa {
	/**
	 * 	
	 * @param urlQuery
	 * @param queryParams
	 * @param requestPath
	 * @param token
	 * @param beanClass
	 * @return
	 */
	public static Object postUrlMap2JavaBean(String urlQuery,String queryParams, String token)
	{
		Object object = null;
		
		String returnQueryList = null;
		returnQueryList = doPost(urlQuery,queryParams,token);
		System.out.println("response:" + returnQueryList);
		object = JSON.parseObject(returnQueryList);

		return object;
	}
	public static <T> T postUrlMap2JavaBean(String urlQuery,String queryParams, String token,Class<T> beanClass)
	{
		T t = null;
		
		String returnQueryList = null;
		returnQueryList = doPost(urlQuery,queryParams,token);
		//System.out.println("response:" + returnQueryList);
		t = JSON.parseObject(returnQueryList, beanClass);

		return t;
	}
	public static <T> T getUrlMap2JavaBean(String urlQuery, String token,Class<T> beanClass)
	{
		T t = null;
		
		String returnQueryList = null;
		returnQueryList = doGet(urlQuery, token);
		//System.out.println("response:" + returnQueryList);
		t = JSON.parseObject(returnQueryList, beanClass);

		return t;
	}
	/**
	 * 获取token
	 * @param url
	 * @param requestBody
	 * @param tokenPathParam
	 * @param token
	 * @return
	 */
	public static TokenZhiMa getToken(String url, String requestBody)
	{
		TokenZhiMa token = null;
		String reToken = null;
		
		reToken = doPost(url,requestBody,null);
		token = JSON.parseObject(reToken, TokenZhiMa.class);

		return token;
	}
	public static String doGet(String url, String token)
	{
		String returnValue = null;
		RequestBody body = null;
		
		OkHttpClient client = new OkHttpClient();

		Request request = null;
		if (token == null || token == "")
		{
			request = new Request.Builder()
					  .url(url)
					  .get()
					  .addHeader("Content-Type", "application/json")
					  .addHeader("Cache-Control", "no-cache")
					  .build();
			
		}else
		{
			request = new Request.Builder()
					  .url(url)
					  .get()
					  .addHeader("Content-Type", "application/json")
					  .addHeader("Cache-Control", "no-cache")
					  .addHeader("token", token)
					  .build();
		}
		try 
		{			
			Response response = client.newCall(request).execute();

			InputStream inputStream = response.body().byteStream();
			try {
				String responseXml = StringUtil.getInputStreamContent(inputStream,"UTF-8");

				returnValue = responseXml;
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return returnValue;
	}	
	public static String doPost(String url, String requestBody,String token)
	{
		String returnValue = null;
		RequestBody body = null;
		
		OkHttpClient client = new OkHttpClient();

		MediaType mediaType = MediaType.parse("application/json");

		body = RequestBody.create(mediaType, requestBody);
		
		Request request = null;
		if (token == null || token == "")
		{
			request = new Request.Builder()
					  .url(url)
					  .post(body)
					  .addHeader("Content-Type", "application/json")
					  .addHeader("Cache-Control", "no-cache")
					  .build();
			
		}else
		{
			request = new Request.Builder()
					  .url(url)
					  .post(body)
					  .addHeader("Content-Type", "application/json")
					  .addHeader("Cache-Control", "no-cache")
					  .addHeader("token", token)
					  .build();
		}
		try {
			Response response = client.newCall(request).execute();
			InputStream inputStream = response.body().byteStream();
			try {
				String responseXml = StringUtil.getInputStreamContent(inputStream,"UTF-8");

				returnValue = responseXml;
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return returnValue;
	}
}
