package com.ajb.car.metadata.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.meta.AgMdVehicleBrand;
import com.ajb.car.metadata.repositories.AgMdVehicleBrandRepository;
import com.ajb.car.metadata.service.AgMdVehicleBrandService;

@Service("agMdVehicleBrandService")
public class AgMdVehicleBrandServiceImpl implements AgMdVehicleBrandService{
	@Autowired
	private AgMdVehicleBrandRepository agMdVehicleBrandRepo;

	public AgMdVehicleBrand save(AgMdVehicleBrand obj){
		return agMdVehicleBrandRepo.save(obj);
	}

	public Boolean delete(Long id) {
		try {
			agMdVehicleBrandRepo .delete(id);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public AgMdVehicleBrand update(AgMdVehicleBrand obj) {
		return agMdVehicleBrandRepo.saveAndFlush(obj);
	}

	public AgMdVehicleBrand findById(Long id){
		return agMdVehicleBrandRepo.findOne(id);
	}
	
	public Page<AgMdVehicleBrand> findByObjPageable(AgMdVehicleBrand obj,Pageable pageable){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgMdVehicleBrand> ex = Example.of(obj, matcher); 
		return agMdVehicleBrandRepo.findAll(ex,pageable);
	}
	
	public List<AgMdVehicleBrand> findByObjSortable(AgMdVehicleBrand obj,Sort sort){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgMdVehicleBrand> ex = Example.of(obj, matcher); 
		return agMdVehicleBrandRepo.findAll(ex,sort);
	}
}