package com.ajb.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.ajb.car.vo.quotation.AgPoQuotationRequestVO;
import com.ajb.car.vo.quotation.QuotationRequestVO;
import com.ajb.common.utils.encryption.MaskUtils;
import com.ajb.web.quotation.AgPoQuotationWebService;

/**
 * 车险报价
 * @author Simon Cheng
 *
 */
@RestController
@RequestMapping(value="/quote")
public class QuotationController {
	@Autowired
	private AgPoQuotationWebService agPoQuotationWebService;
	
	/**
	 * 查询用户报价详细信息（某一个保险公司的）
	 * 保费，保障详情，服务和礼包，车辆信息
	 * @param quotationId
	 * @param model
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/quotation/{quotationId}", method=RequestMethod.GET)
	public AgPoQuotationRequestVO queryAgPoQuotation(@PathVariable String quotationId, Model model) throws Exception{				
		AgPoQuotationRequestVO quotationResponse= agPoQuotationWebService.queryAgPoQuotation(Long.valueOf(quotationId));

		quotationResponse.setCustomerMobileMask(MaskUtils.maskCellphone(quotationResponse.getCustomerMobile()));
		model.addAttribute("quotation", quotationResponse); 
		  	  
		return quotationResponse; 		
	}
	
	/**
	 * 车牌号，车架号，发动机号，车主，身份证号，
	 * 报价查询，能查到去年的历史，返回上年的投保范围方案
	 * 没有的话，就获取车险投保方案（见车险投保推荐方案）
	 * @param requestVO
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/quotation/lastyearquotation")
	public Object lastYearQuotation(@RequestBody QuotationRequestVO requestVO) throws Exception{				
		//ProvinceResponse quotationResponse = new ProvinceResponse();

		return null;	
	}
	/**
	 * 车险投保推荐方案,自选，推荐，基础型三种
	 * @param requestVO
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/quotation/recommendcoverages")
	public Object recommendCoverages(@RequestBody QuotationRequestVO requestVO) throws Exception{				
		//ProvinceResponse quotationResponse = new ProvinceResponse();

		return null;	
	}
	/**
	 * 提交用户报价信息
	 * 参数：用户在一种推荐方案的基础上修改
	 * 返回：根据用户选择的保障范围，查询各家保险公司的报价返回
	 * @param requestVO
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/quotation/postquotation")
	public Object postQuotation(@RequestBody QuotationRequestVO requestVO) throws Exception{				
		//ProvinceResponse quotationResponse = new ProvinceResponse();

		return null;	
	}
	/**
	 * 修改用户报价信息
	 * 参数：用户在一种推荐方案的基础上修改
	 * 返回：根据用户选择的保障范围，查询各家保险公司的报价返回
	 * @param requestVO
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/quotation/modifyquotation")
	public Object modifyQuotation(@RequestBody QuotationRequestVO requestVO) throws Exception{				
		//ProvinceResponse quotationResponse = new ProvinceResponse();

		return null;	
	}
	/**
	 * 确认用户报价信息，阅读保险条款并同意
	 * 参数：阅读保险条款并同意
	 * 返回：
	 * @param requestVO
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/quotation/confirmquotation")
	public Object confirmQuotation(@RequestBody QuotationRequestVO requestVO) throws Exception{				
		//ProvinceResponse quotationResponse = new ProvinceResponse();

		return null;	
	}
	
	/**
	 * 确认用户报价信息后，提交收件地址
	 * 参数：
	 * 返回：
	 * @param requestVO
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/quotation/postrecieveaddress")
	public Object postRecieveAddress(@RequestBody QuotationRequestVO requestVO) throws Exception{				
		//ProvinceResponse quotationResponse = new ProvinceResponse();

		return null;	
	}	
	
	/**
	 * 确认用户报价信息后，提交发票信息
	 * 参数：阅读保险条款并同意
	 * 返回：
	 * @param requestVO
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/quotation/postinvoiceinfo")
	public Object postInvoiceInfo(@RequestBody QuotationRequestVO requestVO) throws Exception{				
		//ProvinceResponse quotationResponse = new ProvinceResponse();

		return null;	
	}
	
}