package com.ajb.car.quotation.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.quotation.AgPoQuotationVehicle;
import com.ajb.car.quotation.repositories.AgPoQuotationVehicleRepository;
import com.ajb.car.quotation.service.AgPoQuotationVehicleService;

@Service("agPoQuotationVehicleService")
public class AgPoQuotationVehicleServiceImpl implements AgPoQuotationVehicleService{
	@Autowired
	private AgPoQuotationVehicleRepository agPoQuotationVehicleRepo;

	public AgPoQuotationVehicle save(AgPoQuotationVehicle obj){
		return agPoQuotationVehicleRepo.save(obj);
	}

	public Boolean delete(Long id) {
		try {
			agPoQuotationVehicleRepo .delete(id);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public AgPoQuotationVehicle update(AgPoQuotationVehicle obj) {
		return agPoQuotationVehicleRepo.saveAndFlush(obj);
	}

	public AgPoQuotationVehicle findById(Long id){
		return agPoQuotationVehicleRepo.findOne(id);
	}
	
	public Page<AgPoQuotationVehicle> findByObjPageable(AgPoQuotationVehicle obj,Pageable pageable){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgPoQuotationVehicle> ex = Example.of(obj, matcher); 
		return agPoQuotationVehicleRepo.findAll(ex,pageable);
	}
	
	public List<AgPoQuotationVehicle> findByObjSortable(AgPoQuotationVehicle obj,Sort sort){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgPoQuotationVehicle> ex = Example.of(obj, matcher); 
		return agPoQuotationVehicleRepo.findAll(ex,sort);
	}
}