package com.ajb.car.quotation.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.quotation.AgPoQuotationVehicleRelation;
import com.ajb.car.quotation.repositories.AgPoQuotationVehicleRelationRepository;
import com.ajb.car.quotation.service.AgPoQuotationVehicleRelationService;

@Service("agPoQuotationVehicleRelationService")
public class AgPoQuotationVehicleRelationServiceImpl implements AgPoQuotationVehicleRelationService{
	@Autowired
	private AgPoQuotationVehicleRelationRepository agPoQuotationVehicleRelationRepo;

	public AgPoQuotationVehicleRelation save(AgPoQuotationVehicleRelation obj){
		return agPoQuotationVehicleRelationRepo.save(obj);
	}

	public Boolean delete(Long id) {
		try {
			agPoQuotationVehicleRelationRepo .delete(id);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public AgPoQuotationVehicleRelation update(AgPoQuotationVehicleRelation obj) {
		return agPoQuotationVehicleRelationRepo.saveAndFlush(obj);
	}

	public AgPoQuotationVehicleRelation findById(Long id){
		return agPoQuotationVehicleRelationRepo.findOne(id);
	}
	
	public Page<AgPoQuotationVehicleRelation> findByObjPageable(AgPoQuotationVehicleRelation obj,Pageable pageable){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgPoQuotationVehicleRelation> ex = Example.of(obj, matcher); 
		return agPoQuotationVehicleRelationRepo.findAll(ex,pageable);
	}
	
	public List<AgPoQuotationVehicleRelation> findByObjSortable(AgPoQuotationVehicleRelation obj,Sort sort){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgPoQuotationVehicleRelation> ex = Example.of(obj, matcher); 
		return agPoQuotationVehicleRelationRepo.findAll(ex,sort);
	}
}