package com.ajb.car.quotation.service.impl;


import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.quotation.AgPoQuotationTax;
import com.ajb.car.quotation.repositories.AgPoQuotationTaxRepository;
import com.ajb.car.quotation.service.AgPoQuotationTaxService;


@Service("agPoQuotationTaxService")
public class AgPoQuotationTaxServiceImpl implements AgPoQuotationTaxService{
	@Autowired
	private AgPoQuotationTaxRepository agPoQuotationTaxRepo;

	public AgPoQuotationTax save(AgPoQuotationTax obj){
		return agPoQuotationTaxRepo.save(obj);
	}

	public Boolean delete(Long id) {
		try {
			agPoQuotationTaxRepo .delete(id);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public AgPoQuotationTax update(AgPoQuotationTax obj) {
		return agPoQuotationTaxRepo.saveAndFlush(obj);
	}

	public AgPoQuotationTax findById(Long id){
		return agPoQuotationTaxRepo.findOne(id);
	}
	
	public Page<AgPoQuotationTax> findByObjPageable(AgPoQuotationTax obj,Pageable pageable){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgPoQuotationTax> ex = Example.of(obj, matcher); 
		return agPoQuotationTaxRepo.findAll(ex,pageable);
	}
	
	public List<AgPoQuotationTax> findByObjSortable(AgPoQuotationTax obj,Sort sort){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgPoQuotationTax> ex = Example.of(obj, matcher); 
		return agPoQuotationTaxRepo.findAll(ex,sort);
	}
}