package com.ajb.car.quotation.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.quotation.AgPoQuotationCover;
import com.ajb.car.quotation.repositories.AgPoQuotationCoverRepository;
import com.ajb.car.quotation.service.AgPoQuotationCoverService;

@Service("agPoQuotationCoverService")
public class AgPoQuotationCoverServiceImpl implements AgPoQuotationCoverService{
	@Autowired
	private AgPoQuotationCoverRepository agPoQuotationCoverRepo;

	public AgPoQuotationCover save(AgPoQuotationCover obj){
		return agPoQuotationCoverRepo.save(obj);
	}

	public Boolean delete(Long id) {
		try {
			agPoQuotationCoverRepo .delete(id);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public AgPoQuotationCover update(AgPoQuotationCover obj) {
		return agPoQuotationCoverRepo.saveAndFlush(obj);
	}

	public AgPoQuotationCover findById(Long id){
		return agPoQuotationCoverRepo.findOne(id);
	}
	
	public Page<AgPoQuotationCover> findByObjPageable(AgPoQuotationCover obj,Pageable pageable){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgPoQuotationCover> ex = Example.of(obj, matcher); 
		return agPoQuotationCoverRepo.findAll(ex,pageable);
	}
	
	public List<AgPoQuotationCover> findByObjSortable(AgPoQuotationCover obj,Sort sort){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgPoQuotationCover> ex = Example.of(obj, matcher); 
		return agPoQuotationCoverRepo.findAll(ex,sort);
	}
}