package com.ajb.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.ajb.car.vo.common.DESCommon;
import com.ajb.car.vo.common.JsonResult;
import com.ajb.car.vo.zhima.user.UserdataRequestVO;
import com.ajb.car.vo.zhima.user.UserdataResponseVO;
import com.ajb.common.utils.encryption.DESUtils;
import com.ajb.common.utils.encryption.JPACryptoConverter;
import com.ajb.web.user.UserdataWebService;

@RestController
public class UserDataController {
	@Autowired
	private UserdataWebService userdataWebService;
	
	@RequestMapping("/userdataquery")
	public Object query(@RequestBody UserdataRequestVO userdataRequestVO) throws Exception{
		JsonResult result = new JsonResult();
		UserdataResponseVO userdataResponseVO = userdataWebService.queryUserdata(userdataRequestVO);
		result.setData(userdataResponseVO);
		return result;
	}
   
    @RequestMapping("/userdatasave")
	public Object save(@RequestBody UserdataRequestVO userdataRequestVO) throws Exception{
		JsonResult result = new JsonResult();
		UserdataResponseVO userdataResponseVO = userdataWebService.saveUserdata(userdataRequestVO);
		result.setData(userdataResponseVO);
		return result;
	}
    
    @RequestMapping("/userdataupdate")
	public Object update(@RequestBody UserdataRequestVO userdataRequestVO) throws Exception{
		JsonResult result = new JsonResult();
		UserdataResponseVO userdataResponseVO = userdataWebService.updateUserdata(userdataRequestVO);
		result.setData(userdataResponseVO);
		return result;
	}
    
    @RequestMapping("/userdataencrypt")
	public Object encrypt(@RequestBody DESCommon requestVO) throws Exception{
		JsonResult result = new JsonResult();
		DESUtils des;
		String resultString = "";
		try {
			JPACryptoConverter jpaCryptoConverter = new JPACryptoConverter();
			resultString = jpaCryptoConverter.convertToDatabaseColumn(requestVO.getContent());
			
			requestVO.setEncrypted(resultString);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		result.setData(requestVO);
		return result;
	}
    @RequestMapping("/userdatadecrypt")
	public Object Decrypt(@RequestBody DESCommon requestVO) throws Exception{
		JsonResult result = new JsonResult();
		DESUtils des;
		String content = "";

		try {
			JPACryptoConverter jpaCryptoConverter = new JPACryptoConverter();
			content = jpaCryptoConverter.convertToEntityAttribute(requestVO.getEncrypted());
			
			requestVO.setContent(content);;
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		result.setData(requestVO);
		return result;
	}
}