package com.ajb.global.config;

import javax.sql.DataSource;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.alibaba.druid.pool.DruidDataSource;

/***
 * alibaba druid datasource configuration
 * 
 * @author fan
 *
 */
@Configuration
public class DruidConfiguration {

	/***
	 * ConditionalOnMissingBean 当不存在时 返回Bean的实例
	 * 通过ConfigurationProperties自动注入配置
	 * @return
	 */
	@Bean
	@ConditionalOnMissingBean
	@ConfigurationProperties(prefix = "spring.datasource")
	public DataSource druidDataSource(){
		DruidDataSource druidDataSource = new DruidDataSource();
		return druidDataSource;
	}
	
}
